const {
    messageCreator
} = require("./MessageCreator");
const _ = require('underscore');

class PacketCreator {
    makePacket(msgesParams) {
        var msg;
        var size;
        var sum;
        if (_.isArray(msgesParams)) {
            msgesParams.forEach(element => {
                if (!msg) {
                    msg = element.data;
                    size = element.size;
                    sum = element.sum;
                } else {
                    msg = msg.concat(element.data);
                    size = size + element.size;
                    sum = sum + element.sum;
                }
            });
        } else {
            msg = msgesParams.data;
            size = msgesParams.size;
            sum = msgesParams.sum;
        }
        var head = messageCreator.makeHeader(size);
        var tail = messageCreator.makeTail(sum);
        var resultcom = head.concat(msg).concat(tail);
        return resultcom;
    }
}

const packetCreator = new PacketCreator();

module.exports = {
    packetCreator,
    PacketCreator
}